import { Link, useLocation } from 'react-router-dom'
import { BookOpen } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-brutal">
      <header className="header-brutal">
        <div className="container">
          <div className="header-content-brutal">
            <Link to="/" className="logo-brutal">
              <div className="logo-icon-wrapper-brutal">
                <BookOpen className="logo-icon-brutal" size={32} />
              </div>
              <span className="logo-text-brutal">CODEHUB</span>
            </Link>
            <nav className="nav-brutal">
              <Link 
                to="/" 
                className={`nav-link-brutal ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои заявки
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-brutal ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-brutal">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

